//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to pass data to the client thread
struct _ClientThreadInfo{
    Server *MyServer;
    int Client;
}; _ClientThreadInfo CTI;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SendMessageToAllClients(Server *pServer, int Client, char *SendData, int SendSize, bool SendToMe)
{
    int ClientLoop = 0;

    if(SendToMe == true)
        Client = -1;

    while(ClientLoop < MaxClients)
    {
        if(pServer->Connected[ClientLoop] && ClientLoop != Client)
        {
            while(!pServer->SetSendDataEx(ClientLoop, SendData, SendSize) && pServer->Connected[ClientLoop])
                Sleep(1);
        }

        ClientLoop++;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread(LPVOID pCTI)
{
    //--------------( Critical section, DO NOT MODIFIY! Begin )-------------
    _ClientThreadInfo *MyCTI = (_ClientThreadInfo *) pCTI;

	Server *pServer = MyCTI->MyServer;
	int Client      = MyCTI->Client;

    pServer->IsClientThreadActive[Client] = true;
    //--------------( Critical section, DO NOT MODIFIY! End )---------------

    char StatusTemp[255];

    FreeSingleClientInfo(Client);

    if(!CI[Client].DBClass.DBConnect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
    {
        sprintf(StatusTemp, "(%d) Error connecting to the web portal index!", pServer->ClientID[Client]);
        WriteLog(StatusTemp);
        return ThreadWaitForDisconnect(pServer, Client);
    }

    SimpleServerSend(Client, "::Authentication");

    int AuthResult = AuthenticateClient(Client);
    if(AuthResult == AUTH_CMD_FAILED)
    {
        sprintf(StatusTemp, "(%d) Authentication: client[%d] failed.", pServer->ClientID[Client], Client);
        WriteLog(StatusTemp);
        return ThreadWaitForDisconnect(pServer, Client);
    }
    else if(AuthResult == AUTH_CMD_SUCCESS){
        sprintf(StatusTemp, "(%d) Authentication: client[%d] succeeded.", pServer->ClientID[Client], Client);
        WriteLog(StatusTemp);
    }
    else if(AuthResult == AUTH_CMD_DISCONNECT){
        sprintf(StatusTemp, "(%d) Authentication: client[%d] disconnect.", pServer->ClientID[Client], Client);
        WriteLog(StatusTemp);
        return ThreadWaitForDisconnect(pServer, Client);
    }
    else{
        sprintf(StatusTemp, "(%d) Authentication: client[%d] error.", pServer->ClientID[Client], Client);
        WriteLog(StatusTemp);
        return ThreadWaitForDisconnect(pServer, Client);
    }

    CI[Client].DBClass.DBCloseCursor(&CI[Client].StatementHandle);
    CI[Client].StatementHandle = NULL;
    CI[Client].DBClass.DBDisconnect();

    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    while(pServer->Connected[Client])
    {
        if( pServer->GetReceiveData(Client, ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            sprintf(StatusTemp, "(%d) Received %d bytes from client[%d].", pServer->ClientID[Client], ReceiveSize, Client);
            WriteLog(StatusTemp);

            int CmdResult = ProcessCommand(Client, ReceiveData, ReceiveSize);
            if(CmdResult == COMMAND_RESULT_UNKNOWN)
            {
                sprintf(StatusTemp, "(%d) Result: COMMAND_RESULT_UNKNOWN.", pServer->ClientID[Client]);
                WriteLog(StatusTemp);
                return ThreadWaitForDisconnect(pServer, Client);
            }
            else if(CmdResult == COMMAND_RESULT_DISCONNECT){
                sprintf(StatusTemp, "(%d) Result: COMMAND_RESULT_DISCONNECT.", pServer->ClientID[Client]);
                WriteLog(StatusTemp);
                return ThreadWaitForDisconnect(pServer, Client);
            }
            else if(CmdResult == COMMAND_RESULT_OK){
                sprintf(StatusTemp, "(%d) Result: COMMAND_RESULT_OK.", pServer->ClientID[Client]);
                WriteLog(StatusTemp);
            }
            else{
                sprintf(StatusTemp, "(%d) Result: Error occured.", pServer->ClientID[Client]);
                WriteLog(StatusTemp);
                return ThreadWaitForDisconnect(pServer, Client);
            }
        }
        else Sleep(glTCPLoopDelay);
    }

    return ThreadWaitForDisconnect(pServer, Client);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

